import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:six_pos/features/account_management/domain/models/transaction_model.dart';
import 'package:six_pos/helper/extension_helper.dart';
import 'package:six_pos/helper/price_converter_helper.dart';
import 'package:six_pos/util/dimensions.dart';
import 'package:six_pos/util/styles.dart';
import 'package:six_pos/common/widgets/custom_divider.dart';

class TransactionCardViewWidget extends StatelessWidget {
  final Transfers? transfer;
  final int? index;
  const TransactionCardViewWidget({Key? key, this.index, this.transfer}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(height: 5, color: Theme.of(context).primaryColor.withValues(alpha:0.06)),

        Container(color: Theme.of(context).cardColor, child: Column(children: [
          ListTile(
            visualDensity: const VisualDensity(horizontal: 0, vertical: -4),
            leading: Text('${index ?? 0 + 1}.', style: ubuntuRegular.copyWith(color: Theme.of(context).secondaryHeaderColor),),
            title: Column( crossAxisAlignment: CrossAxisAlignment.start,children: [
              Text('${'account_type'.tr}: ${transfer!.account != null? transfer!.account!.account : ''}', style: ubuntuMedium.copyWith(color: Theme.of(context).primaryColor),),
              const SizedBox(height: Dimensions.paddingSizeExtraSmall),

              Text('${'type'.tr}: ${transfer!.tranType}', style: ubuntuMedium.copyWith(color: context.customThemeColors.textColor),),
              const SizedBox(height: Dimensions.paddingSizeExtraSmall),

              Text('${'transaction_date'.tr}: ${transfer!.date}', style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor),),
              const SizedBox(height: Dimensions.paddingSizeExtraSmall),

              Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
                Text('${'debit'.tr}: ', style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor)),

                Text('- ${transfer!.debit == 1? PriceConverterHelper.priceWithSymbol(transfer!.amount!): 0}', style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor)),

              ],),
              const SizedBox(height: Dimensions.paddingSizeExtraSmall),

              Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
                Text('${'credit'.tr}: ', style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor)),

                Text('${transfer!.credit == 1? PriceConverterHelper.priceWithSymbol(transfer!.amount!) : 0}', style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor)),

              ],),
              const SizedBox(height: Dimensions.paddingSizeExtraSmall),

            ]),

          ),

          Padding(
            padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault),
            child: CustomDividerWidget(color: Theme.of(context).hintColor),
          ),

          ListTile(
            visualDensity: const VisualDensity(horizontal: 0, vertical: -4),
            leading: const SizedBox(),
            title: Text('balance'.tr, style: ubuntuRegular.copyWith(color: context.customThemeColors.textColor)),
            trailing: Text(PriceConverterHelper.priceWithSymbol(transfer!.balance!), style: ubuntuRegular.copyWith(color: Theme.of(context).hintColor)),
          ),


          Padding(
            padding: const EdgeInsets.symmetric(horizontal: Dimensions.paddingSizeDefault,vertical: Dimensions.paddingSizeSmall),
            child: Row(children: [
              Text('${'description'.tr} : ', style: ubuntuRegular.copyWith(color: context.customThemeColors.textColor)),

              Expanded(
                child: Text(
                  '- ${transfer!.description}',
                  maxLines: 1,
                  overflow: TextOverflow.ellipsis,
                  style: ubuntuRegular.copyWith(
                    color:  Theme.of(context).hintColor,
                  ),
                ),
              ),

            ],),
          ),



        ],),),

        Container(height: 5, color: Theme.of(context).primaryColor.withValues(alpha:0.06)),
      ],
    );
  }
}
